/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.common.iterators;

import com.ishland.c2me.notickvd.common.iterators.ChunkIterator;
import java.util.NoSuchElementException;
import net.minecraft.class_1923;

public class SpiralIterator
implements ChunkIterator {
    private static final int RIGHT = 0;
    private static final int DOWN = 1;
    private static final int LEFT = 2;
    private static final int UP = 3;
    private final int originX;
    private final int originZ;
    private final int radius;
    private final long total;
    private boolean needStep = false;
    private int x;
    private int z;
    private int spanTotal = 1;
    private int spanCount = 0;
    private int spanProgress = 0;
    private int direction = 0;
    private long currentIndex;

    public SpiralIterator(int originX, int originZ, int radius) {
        this.originX = originX;
        this.originZ = originZ;
        this.radius = radius;
        this.x = originX;
        this.z = originZ;
        this.total = ((long)radius * 2L + 1L) * ((long)radius * 2L + 1L);
    }

    @Override
    public boolean hasNext() {
        return this.x != this.originX + this.radius || this.z != this.originZ + this.radius;
    }

    @Override
    public class_1923 next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.needStep) {
            switch (this.direction) {
                case 0: {
                    ++this.x;
                    break;
                }
                case 1: {
                    --this.z;
                    break;
                }
                case 2: {
                    --this.x;
                    break;
                }
                case 3: {
                    ++this.z;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++this.spanProgress;
            if (this.spanProgress == this.spanTotal) {
                this.spanProgress = 0;
                ++this.spanCount;
                if (this.spanCount >= 2) {
                    ++this.spanTotal;
                    this.spanCount = 0;
                }
                ++this.direction;
                this.direction %= 4;
            }
        }
        this.needStep = true;
        ++this.currentIndex;
        return new class_1923(this.x, this.z);
    }

    @Override
    public long remaining() {
        return this.total - this.currentIndex;
    }

    @Override
    public long total() {
        return this.total;
    }

    @Override
    public int originX() {
        return this.originX;
    }

    @Override
    public int originZ() {
        return this.originZ;
    }

    @Override
    public int radius() {
        return this.radius;
    }
}

